//
//  CMSPasswordRecoverViewController.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 17/10/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
let STORYBOARD_ID_CMSPasswordRecoverViewController = "CMSPasswordRecoverViewController"
import UIKit

class CMSPasswordRecoverViewController: UIViewController, UITextFieldDelegate, CMSNetworkManager_RecoverPasswordDelegate {
    @IBOutlet var txtEmail: UITextField!
    @IBOutlet weak var lblForgotPassword: UILabel!
    @IBOutlet weak var lblUsername: UILabel!
    @IBOutlet weak var btnSubmit: UIButton!
    @IBOutlet weak var btnCancel: UIButton!

    @IBAction func btnSubmit(sender: AnyObject) {
        var errorMessage = self.validateForm()
        if errorMessage != "" {
            UIAlertView(title: "", message: errorMessage, delegate: nil, cancelButtonTitle: nil).show()
            return
        }
        CMSNetworkManager.sharedManager().recoverPasswordDelegate = self
        CMSNetworkManager.sharedManager().recoverPasswordWithEmail(txtEmail.text, onCompletion: nil, onFaillure: nil, showLoader: true)
    }

    @IBAction func btnCancel(sender: AnyObject) {
        if self.isPresentedAsModal() {
            self.dismissViewControllerAnimated(true, completion: { _ in })
        }
        else {
            self.navigationController!.popViewControllerAnimated(true)!
        }
    }


    convenience override init() {
        var storyboard = UIStoryboard(name: CMS_STORYBOARD_NAME, bundle: nil)
        self = storyboard.instantiateViewControllerWithIdentifier(STORYBOARD_ID_CMSPasswordRecoverViewController)
    }

    override func viewDidLoad() {
        super.viewDidLoad()
        self.lblForgotPassword.text = CMS_Langs.do_lang(LABEL_PASSWORD_RECOVER_FORGOT_PASSWORD)
        self.lblUsername.text = CMS_Langs.do_lang(LABEL_PASSWORD_RECOVER_EMAIL)
        self.btnSubmit.setTitle(CMS_Langs.do_lang(BUTTON_PASSWORD_RECOVER_SUBMIT), forState: .Normal)
        self.btnCancel.setTitle(CMS_Langs.do_lang(BUTTON_PASSWORD_RECOVER_CANCEL), forState: .Normal)
        self.title = "Reset Password"
    }

    func isPresentedAsModal() -> Bool {
        var isModal = (self.parentViewController! && self.parentViewController!.modalViewController == self) ||             //or if I have a navigation controller, check if its parent modal view controller is self navigation controller
(self.navigationController! && self.navigationController!.parentViewController! && self.navigationController!.parentViewController!.modalViewController == self.navigationController!) ||             //or if the parent of my UITabBarController is also a UITabBarController class, then there is no way to do that, except by using a modal presentation
(self.tabBarController!.parentViewController! is UITabBarController)
        //iOS 5+
        if !isModal && self.respondsToSelector(self.presentingViewController) {
            isModal = (self.presentingViewController && self.presentingViewController.modalViewController == self) ||             //or if I have a navigation controller, check if its parent modal view controller is self navigation controller
(self.navigationController! && self.navigationController!.presentingViewController && self.navigationController!.presentingViewController.modalViewController == self.navigationController!) ||             //or if the parent of my UITabBarController is also a UITabBarController class, then there is no way to do that, except by using a modal presentation
(self.tabBarController!.presentingViewController! is UITabBarController)
        }
        return isModal
    }

    func validateForm() -> String {
        var errorMessage: String
        if !(self.txtEmail.text.length >= 1) {
            errorMessage = "Please enter Email address"
        }
        return errorMessage
    }
// MARK: - TextFieldDelegate Methods

    func textFieldShouldReturn(textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return true
    }
// MARK: - CMSNetworkManager_RecoverPasswordDelegate methods

    func CMSNetworkManager(manager: CMSNetworkManager, didRecoverPasswordWithResponse response: [NSObject : AnyObject]) {
        print("Recover Password Request Successful")
        print("\(response)")
        UIAlertView(title: response["response_data"]["message"], message: nil, delegate: nil, cancelButtonTitle: nil).show()
    }

    func CMSNetworkManager(manager: CMSNetworkManager, didFailToRecoverPasswordWithError error: NSError?) {
        UIAlertView(title: "", message: "Recover Password Request failed", delegate: nil, cancelButtonTitle: nil).show()
        print("\(error.description)")
    }
}
//
//  PasswordRecoverViewController.m
//  Composr Mobile SDK
//
//  Created by Aaswini on 17/10/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
let LABEL_PASSWORD_RECOVER_FORGOT_PASSWORD = "LABEL_PASSWORD_RECOVER_FORGOT_PASSWORD"
let LABEL_PASSWORD_RECOVER_EMAIL = "LABEL_PASSWORD_RECOVER_EMAIL"
let BUTTON_PASSWORD_RECOVER_SUBMIT = "BUTTON_PASSWORD_RECOVER_SUBMIT"
let BUTTON_PASSWORD_RECOVER_CANCEL = "BUTTON_PASSWORD_RECOVER_CANCEL"